#import "EaglUIVIew.h"
#import <QuartzCore/QuartzCore.h>
#import "VSLogging.h"

@implementation EaglUIView
{
    EAGLContext *_context;
}

+ (Class) layerClass
{
    return [CAEAGLLayer class];
}

-(CALayer *) layer
{
    return super.layer;
}

-(EAGLContext *) getContext
{
    if (_context == nil)
    {
        _context = [[EAGLContext alloc] initWithAPI:kEAGLRenderingAPIOpenGLES2];
    }
    return _context;
}

-(void) makeContextCurrent
{
    EAGLContext *ownContext = [self getContext];
    if ([EAGLContext currentContext] != ownContext)
    {
        [EAGLContext setCurrentContext:ownContext];
    }
}

@end
